package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class SecureMessageRequestBuilder {
	protected RequestMessage request;
	
	protected SecureMessageRequestBuilder(RequestMessage request) {
		this.request = request;
		request.setValue("scope-filter", ScopeFilter.getInstanceForLongitudinalScope());
	}
	
	public static SecureMessageRequestBuilder forSecureMessageUser() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchSecureMessageUser");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forSecureMessageContacts() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchSecureMessageContact");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forSecureMessageFolders() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchSecureMessageFolder");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forSecureMessageData() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchSecureMessageData");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forReadSecureMessage() {
		RequestMessage request = new RequestMessage();
		request.setType("ReadSecureMessage");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forSendSecureMessage() {
		RequestMessage request = new RequestMessage();
		request.setType("SendSecureMessage");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forReplySecureMessage() {
		RequestMessage request = new RequestMessage();
		request.setType("ReplySecureMessage");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forMoveSecureMessage() {
		RequestMessage request = new RequestMessage();
		request.setType("MoveSecureMessage");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forSaveSecureMessage() {
		RequestMessage request = new RequestMessage();
		request.setType("SaveSecureMessage");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forSendSecureMessageDraft() {
		RequestMessage request = new RequestMessage();
		request.setType("SendSecureMessageDraft");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public static SecureMessageRequestBuilder forDeleteSecureMessageDraft() {
		RequestMessage request = new RequestMessage();
		request.setType("DeleteSecureMessageDraft");
		SecureMessageRequestBuilder builder = new SecureMessageRequestBuilder(request);
		return builder;
	}
	
	public SecureMessageRequestBuilder forUserIdentifier(PatientIdentifier userIdentifier) {
		request.setValue("user-identifier", userIdentifier);
		return this;
	}
	
	public SecureMessageRequestBuilder forDomain(String domain) {
		request.setValue("domain", domain);
		return this;
	}
	
	public SecureMessageRequestBuilder forFilter(SecureMessageFilter filter) {
		request.setValue("secure-message-filter", filter);
		return this;
	}
	
	public SecureMessageRequestBuilder forSecureMessage(SecureMessage secureMessage) {
		request.setValue("secure-message", secureMessage);
		return this;
	}
	
	public RequestMessage build() {
		return request;
	}
	
}
