package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageFolders;

public class SecureMessageFolderResponseBuilder {
	private ResponseMessage response;
	
	private SecureMessageFolderResponseBuilder(ResponseMessage response) {
		this.response = response;
	}
	
	public static SecureMessageFolderResponseBuilder fromSecureMessageUser(SecureMessageFolders folders) {
		ResponseMessage response = new ResponseMessage();
		response.setValue("secure-message-folders", folders);
		SecureMessageFolderResponseBuilder builder = new SecureMessageFolderResponseBuilder(response);
		
		return builder;
	}
	
	public ResponseMessage build() {
		return response;
	}
}
