package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageContacts;

public class SecureMessageContactResponseBuilder {
	private ResponseMessage response;
	
	private SecureMessageContactResponseBuilder(ResponseMessage response) {
		this.response = response;
	}
	
	public static SecureMessageContactResponseBuilder fromSecureMessageUser(SecureMessageContacts contacts) {
		ResponseMessage response = new ResponseMessage();
		response.setValue("secure-message-contacts", contacts);
		SecureMessageContactResponseBuilder builder = new SecureMessageContactResponseBuilder(response);
		
		return builder;
	}
	
	public ResponseMessage build() {
		return response;
	}
}
