package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import java.util.Collection;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.SecureMessageRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageUser;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DataSystem;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class FetchSecureMessageUserRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		SecureMessageRequestReader requestReader = SecureMessageRequestReader.fromRequest(requestMessage);
		
		PatientIdentifier translatedIdentifier = translatePatientIdentifier(requestReader);
		requestReader.updateUserIdentifier(translatedIdentifier);
		
		SecureMessageDataLayer dataLayer = getDataLayer(requestMessage);
		SecureMessageUser user = invokeDataLayer(dataLayer, requestMessage, requestReader);
		
		return SecureMessageUserResponseBuilder.fromSecureMessageUser(user).build();
	}

	private SecureMessageDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
	
	SecureMessageUser invokeDataLayer(SecureMessageDataLayer dataLayer, RequestMessage requestMessage, SecureMessageRequestReader requestReader) {
		return dataLayer.fetchSecureMessageUser(requestReader.getPatientId());
	}
	
	private Collection<DataSystem> determineDataSystemList() {
		DomainServiceRegistry registry = new DomainServiceRegistry();
		return registry.getDataSystems(ScopeFilter.getInstanceForLongitudinalScope(), Domain.secureMessage);
	}
	
	private PatientIdentifier translatePatientIdentifier(SecureMessageRequestReader requestReader) {
		Collection<DataSystem> dataSystems = determineDataSystemList();
		
		// FIXME: This does not work when the System is used in the SM user atomlink. Need to verify
		for(DataSystem targetDataSystem : dataSystems) {
			PatientIdentifiers correspondingIdentifiers = MhpObjectFactory.getInstance().getPatientCorrelationService().getCorrespondIdentifiers(requestReader.getPatientIdentifier(), targetDataSystem.getPatientAssigningAuthority());
			for(PatientIdentifier userIdentifier : correspondingIdentifiers) {
				return userIdentifier;
			}
		}
		
		return requestReader.getPatientIdentifier();
	}
}
