package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.SecureMessageRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessages;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class FetchSecureMessageListRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		SecureMessageRequestReader messageReader = SecureMessageRequestReader.fromRequest(requestMessage);
		SecureMessageDataLayer dataLayer = getDataLayer(requestMessage);
		SecureMessages messages = invokeDataLayer(dataLayer, requestMessage, messageReader);
		
		return SecureMessageResponseBuilder.fromSecureMessages(messages).build();
	}
	
	private SecureMessageDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
	
	SecureMessages invokeDataLayer(SecureMessageDataLayer dataLayer, RequestMessage requestMessage, SecureMessageRequestReader requestReader) {
		return dataLayer.fetchSecureMessages(requestReader.getPatientId(), requestReader.getSecureMessageFilter());
	}
}
