package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.SecureMessageRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageCode;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageFolder;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageFolders;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class FetchSecureMessageFolderRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		SecureMessageRequestReader messageReader = SecureMessageRequestReader.fromRequest(requestMessage);
		SecureMessageDataLayer dataLayer = getDataLayer(requestMessage);
		SecureMessageFolders folders = invokeDataLayer(dataLayer, requestMessage, messageReader);
		folders = filterFoldersByUserType(folders);
		
		return SecureMessageFolderResponseBuilder.fromSecureMessageUser(folders).build();
	}

	private SecureMessageDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
	
	SecureMessageFolders invokeDataLayer(SecureMessageDataLayer dataLayer, RequestMessage requestMessage, SecureMessageRequestReader requestReader) {
		return dataLayer.fetchFolders(requestReader.getPatientId());
	}
	
	SecureMessageFolders filterFoldersByUserType(SecureMessageFolders folders) {
		SecureMessageFolders filteredFolders = new SecureMessageFolders();

        if(folders == null)
            return filteredFolders;

        for(SecureMessageFolder folder : folders) {
			setMoveable(folder);
			filteredFolders.add(folder);
		}
		
		return filteredFolders;
	}
	
	void setMoveable(SecureMessageFolder folder) {
		if(SecureMessageCode.FOLDER_ID_INBOX.toString().equals(folder.getUniqueId()) || SecureMessageCode.FOLDER_ID_DELETED.equals(folder.getUniqueId()) || Integer.parseInt(folder.getUniqueId()) > 0) {
			folder.setMovable(true);
		}
		folder.setMovable(false);
	}

}
