package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.SecureMessageRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageContacts;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class FetchSecureMessageContactRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		SecureMessageRequestReader messageReader = SecureMessageRequestReader.fromRequest(requestMessage);
		SecureMessageDataLayer dataLayer = getDataLayer(requestMessage);
		SecureMessageContacts contacts = invokeDataLayer(dataLayer, requestMessage, messageReader);
		
		return SecureMessageContactResponseBuilder.fromSecureMessageUser(contacts).build();
	}

	private SecureMessageDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
	
	SecureMessageContacts invokeDataLayer(SecureMessageDataLayer dataLayer, RequestMessage requestMessage, SecureMessageRequestReader requestReader) {
		return dataLayer.fetchContacts(requestReader.getPatientId());
	}
}
