package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.SecureMessageRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public abstract class AbstractSecureMessageRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		SecureMessageRequestReader messageReader = SecureMessageRequestReader.fromRequest(requestMessage);
		SecureMessageDataLayer dataLayer = getDataLayer(requestMessage);
		SecureMessage dataItem = invokeDataLayer(dataLayer, requestMessage, messageReader);
		if (dataItem != null) {
			dataItem.setPatientIdentifier(messageReader.getPatientIdentifier());
		}
		return SecureMessageResponseBuilder.fromSecureMessage(dataItem).build();
	}

	private SecureMessageDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}

	protected abstract SecureMessage invokeDataLayer(SecureMessageDataLayer dataLayer, RequestMessage requestMessage, SecureMessageRequestReader requestReader);
}