package com.agilex.healthcare.mobilehealthplatform.datalayer.radiology;

import java.util.Collections;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityCache;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyTest;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyTests;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.PatientIdentifierHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.RadiologyResultComparator;
import com.agilex.healthcare.vamf.cdw.radiology.CdwRadiologyDataLayer;

public class RadiologyDataService {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(RadiologyDataService.class);

	private Router router = new Router();
	private CdwRadiologyDataLayer layer;

	public RadiologyDataService() {
		layer = MhpObjectFactory.getInstance().getCdwRadiologyDataLayer();
	}

	public RadiologyTests getRadiologyTests(PatientIdentifier patientIdentifier, DateFilter filter, ScopeFilter scopeFilter) {
		RadiologyResults results = getRadiologyResults(patientIdentifier, filter, scopeFilter);
		logger.debug(String.format("retrieved %s results", results.size()));

		RadiologyTests tests = new RadiologyTests();
		for (RadiologyResult result : results) {
			RadiologyTest test = tests.getTestById(result.getTestShortName());
			if (test == null) {
				test = new RadiologyTest();
				test.setUniqueId(result.getUniqueId());
				test.setTestName(result.getTestName());
				test.setShortName(result.getTestShortName());
				tests.add(test);
			}
			test.getRadiologyResults().add(result);
		}
		PatientIdentifierHelper.updatePatientIdentifier(tests, patientIdentifier);

		sort(tests);
		
		return tests;
	}
	
	private void sort(RadiologyTests tests) {
		for (RadiologyTest test : tests) {
			test.getRadiologyResults().sortDescending("resultedDate");
		}
		tests.sortAscending("shortName");
	}

	public RadiologyResults getRadiologyResults(PatientIdentifier patientIdentifier, DateFilter dateFilter, ScopeFilter scopeFilter) {
		PatientIdentifiers dfnPatientIdentifiers = PatientIdentifierHelper.translatePatientIdentifier(patientIdentifier, "dfn");
		if(NullChecker.isNullish(dfnPatientIdentifiers))
			return new RadiologyResults();
/*		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.radiologyResult).forPatientIdentifier(patientIdentifier).forScopeFilter(scopeFilter).forDateFilter(dateFilter).build();
		ResponseMessage responseMessage = router.execute(request);
		RadiologyResults radiologyResults = PatientDataResponseReader.<RadiologyResults, RadiologyResult> fromResponse(responseMessage).getDataListNoNull(RadiologyResults.class);*/
		RadiologyResults radiologyResults = layer.getResults(PatientIdentifierHelper.getDfnPatientidentifierForQuery(dfnPatientIdentifiers), dateFilter);
		PatientIdentifierHelper.updatePatientIdentifier(radiologyResults, patientIdentifier);
		convertFacility(radiologyResults);
		Collections.sort(radiologyResults, new RadiologyResultComparator());
		
		return radiologyResults;
	}

	public RadiologyResult getRadiologyResult(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier) {
		/*RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveSingleById().forDomain(Domain.radiologyResult).forPatientIdentifier(patientIdentifier).forDataIdentifier(dataIdentifier).build();
		ResponseMessage responseMessage = router.execute(request);
		RadiologyResult radiologyResult = PatientDataResponseReader.<RadiologyResults, RadiologyResult> fromResponse(responseMessage).getDataItem();*/
		PatientIdentifiers dfnPatientIdentifiers = PatientIdentifierHelper.translatePatientIdentifier(patientIdentifier,  "dfn");
		RadiologyResult radiologyResult = layer.fetchResult(PatientIdentifierHelper.getDfnPatientidentifierForQuery(dfnPatientIdentifiers), dataIdentifier.getUniqueId());
		convertFacility(radiologyResult);
		PatientIdentifierHelper.updatePatientIdentifier(radiologyResult, patientIdentifier);
		return radiologyResult;
	}
	
	private void convertFacility(RadiologyResult result) {
		String facilityName = FacilityCache.getInstance().getFacilityName(result.getSourceSystem());
		result.setFacilityName(facilityName);
		result.setSourceSystem(facilityName);
	}
	
	private void convertFacility(RadiologyResults results) {
		for (RadiologyResult result : results) {
			convertFacility(result);
		}
	}
}
