package com.agilex.healthcare.mobilehealthplatform.datalayer.radiology;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;

public class FetchRadiologyListRequestHandler extends AbstractFetchPatientDataListRequestHandler<RadiologyDataLayer, RadiologyResults, RadiologyResult> {

	@Override
	protected RadiologyResults invokeDataLayerToFetchList(RadiologyDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.getResults(messageReader.getPatientIdentifier(), messageReader.getDateFilter());
	}
}
