package com.agilex.healthcare.mobilehealthplatform.datalayer.provider;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProvider;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class ProviderDataService {
	
	private Router router = new Router();
    public final static String facilitySystemCodeKey = "facilitySystemcode";

    public ProviderDataService() {
	}
	
	public ProviderDataService(Router router) {
		this.router = router;
	}

	public PatientProviders fetchPrimaryCareProviders(PatientIdentifier patientIdentifier, String facilitySystemCode){
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.PrimaryCareProvider).forPatientIdentifier(patientIdentifier).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope()).setValue(facilitySystemCodeKey, facilitySystemCode).build();
		ResponseMessage responseMessage = router.execute(request);

		PatientProviders providers = PatientDataResponseReader.<PatientProviders, PatientProvider> fromResponse(responseMessage).getDataListNoNull(PatientProviders.class);
		return providers;

	}

	public PatientProviders fetchMentalHealthProviders(PatientIdentifier patientIdentifier, DateFilter dateFilter){
        return fetchMentalHealthProviders(patientIdentifier, dateFilter, "");
	}

	public PatientProviders fetchMentalHealthProviders(PatientIdentifier patientIdentifier, DateFilter dateFilter, String facilitySystemCode){
        RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.MentalHealthProvider).forPatientIdentifier(patientIdentifier).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope()).forDateFilter(dateFilter).setValue(facilitySystemCodeKey, facilitySystemCode).build();
		ResponseMessage responseMessage = router.execute(request);

		PatientProviders providers = PatientDataResponseReader.<PatientProviders, PatientProvider> fromResponse(responseMessage).getDataListNoNull(PatientProviders.class);
		providers.sortDescending("visitDate");
		return providers;
	}

}
