package com.agilex.healthcare.mobilehealthplatform.datalayer.provider;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProvider;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;

public class FetchPrimaryCareProviderListRequestHandler extends AbstractFetchPatientDataListRequestHandler<ProviderDataLayer, PatientProviders, PatientProvider> {

	@Override
	protected PatientProviders invokeDataLayerToFetchList(ProviderDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		String facilityCode =  requestMessage.getValueAsString(ProviderDataService.facilitySystemCodeKey);
		return datalayer.fetchPrimaryCareProviders(messageReader.getPatientIdentifier(), facilityCode);
	}

}
