package com.agilex.healthcare.mobilehealthplatform.datalayer.problem;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.PatientIdentifierHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.vamf.cdw.problems.CdwProblemDataLayer;

import edu.emory.mathcs.backport.java.util.Collections;

public class ProblemDataService {

	private Router router = new Router();
    private CdwProblemDataLayer layer;
    
	public ProblemDataService() {
		layer = MhpObjectFactory.getInstance().getCdwProblemDataLayer();
	}

	public Problems fetchProblems(PatientIdentifier patientIdentifier, DateFilter dateFilter, ScopeFilter scopeFilter) {
		/*RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.problem).forDateFilter(dateFilter).forPatientIdentifier(patientIdentifier).forScopeFilter(scopeFilter).build();
		ResponseMessage responseMessage = router.execute(request);
		Problems problems = PatientDataResponseReader.<Problems, Problem> fromResponse(responseMessage).getDataListNoNull(Problems.class);*/
		PatientIdentifiers icnPatientIdentifiers = PatientIdentifierHelper.translatePatientIdentifier(patientIdentifier, "ICN");
		if(NullChecker.isNullish(icnPatientIdentifiers))
			return new Problems();
		Problems problems = layer.fetchProblems(icnPatientIdentifiers.get(0), dateFilter);
		PatientIdentifierHelper.updatePatientIdentifier(problems, patientIdentifier);
		Collections.sort(problems);

		return problems;
	}

	public Problem fetchProblem(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveSingleById().forDomain(Domain.problem).forPatientIdentifier(patientIdentifier).forDataIdentifier(dataIdentifier).build();
		ResponseMessage responseMessage = router.execute(request);
		Problem problem = PatientDataResponseReader.<Problems, Problem> fromResponse(responseMessage).getDataItem();
		return problem;
	}
}
