package com.agilex.healthcare.mobilehealthplatform.datalayer.problem;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;

public class FetchProblemListRequestHandler extends AbstractFetchPatientDataListRequestHandler<ProblemDataLayer, Problems, Problem> {

	@Override
	protected Problems invokeDataLayerToFetchList(ProblemDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.fetchProblems(messageReader.getPatientIdentifier(), messageReader.getDateFilter());
	}
}
