package com.agilex.healthcare.mobilehealthplatform.datalayer.preference;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class SavePreferenceRequestHandler implements RequestHandler {
	
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory
			.getLog(SavePreferenceRequestHandler.class);
	

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientPreferenceDataLayer datalayer = getDataLayer(requestMessage);

		PatientDataFetchRequestReader messageReader = PatientDataFetchRequestReader.fromRequest(requestMessage);
		
		PatientPreference pref = datalayer.updatePatientPreference(messageReader.getPreference());		

		return PreferenceFetchResponseBuilder.fromPreference(pref).build();
	}

	private PatientPreferenceDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
	

}
