package com.agilex.healthcare.mobilehealthplatform.datalayer.preference;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;

public class PreferenceFetchResponseBuilder {
	private ResponseMessage response;

	private PreferenceFetchResponseBuilder(ResponseMessage response) {
		this.response = response;
	}

	public static PreferenceFetchResponseBuilder newInstance() {
		ResponseMessage response = new ResponseMessage();
		return new PreferenceFetchResponseBuilder(response);
	}

	public static PreferenceFetchResponseBuilder fromPatientData(Patient patient) {
		ResponseMessage response = new ResponseMessage();
		PreferenceFetchResponseBuilder builder = new PreferenceFetchResponseBuilder(response);
		builder.setPatient(patient);
		return builder;
	}

	private PreferenceFetchResponseBuilder setPatient(Patient patient) {
		response.setValue("patient", patient);
		return this;
	}

	public static PreferenceFetchResponseBuilder fromPreference(PatientPreference pref) {
		ResponseMessage response = new ResponseMessage();
		PreferenceFetchResponseBuilder builder = new PreferenceFetchResponseBuilder(response);
		builder.setPreference(pref);
		return builder;
	}

	private PreferenceFetchResponseBuilder setPreference(PatientPreference pref) {
		response.setValue("preference", pref);
		return this;
	}

	public ResponseMessage build() {
		return response;
	}

}
