package com.agilex.healthcare.mobilehealthplatform.datalayer.preference;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;

public class PreferenceFetchRequestBuilder extends PatientDataFetchRequestBuilder {
	protected PreferenceFetchRequestBuilder(RequestMessage request) {
		super(request);
	}

	
	public static PreferenceFetchRequestBuilder forRetrievePreference() {
		RequestMessage request = new RequestMessage();
		PreferenceFetchRequestBuilder builder = new PreferenceFetchRequestBuilder(request);
		request.setType("FetchPatientPreference");
		builder.forDomain("preference");
		return builder;
	}
	
	public static PreferenceFetchRequestBuilder forSavingPreference(){
		RequestMessage request = new RequestMessage();
		request.setType("CreatePatientPreference");
		PreferenceFetchRequestBuilder builder = new PreferenceFetchRequestBuilder(request);
		builder.forDomain("preference");
		return builder;
	}
	
	public PreferenceFetchRequestBuilder forDomain(String domain) {
		request.setValue("domain", domain);
		return this;
	}
	
	public PreferenceFetchRequestBuilder forPreference(PatientPreference pref) {
		request.setValue("preference", pref);
		return this;
	}
}