package com.agilex.healthcare.mobilehealthplatform.datalayer.preference;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientFetchResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.restservice.exception.InvalidPreferenceDetailsException;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.validator.preference.PreferenceValidator;

/***
 * This covers calendar events created by the veteran. These are items to show
 * up on their calendar that are not "appointments"
 * 
 * @author ???
 * 
 */
public class PatientPreferenceDataService {

	private Router router = new Router();
	PatientPreferenceDataLayer patientPreferenceDataLayer;

	public PatientPreferenceDataService() {
		patientPreferenceDataLayer = MhpObjectFactory.getInstance().getPatientPreferenceDataLayer();
	}

	public PatientPreference fetchPatientPreference(PatientIdentifier patientIdentifier) {
		RequestMessage request = PreferenceFetchRequestBuilder.forRetrievePreference().forDomain(Domain.patientPreference).forPatientIdentifier(patientIdentifier).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage responseMessage = router.execute(request);
		return PatientFetchResponseReader.fromResponse(responseMessage).getPreference();
	}

	public PatientPreference updatePatientPreference(PatientPreference patPref){
		validatePatientPreference(patPref);
		RequestMessage request = PreferenceFetchRequestBuilder.forSavingPreference().forDomain(Domain.patientPreference).forPreference(patPref).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage responseMessage = router.execute(request);
		return PatientFetchResponseReader.fromResponse(responseMessage).getPreference();
	}
	
	private void validatePatientPreference(PatientPreference patPref) {
			PreferenceValidator validator = new PreferenceValidator();
				ValidationResult<PatientPreference> validationResult = validator.validate(patPref);
				if (!validationResult.isValid()) {
					throw new InvalidPreferenceDetailsException(validationResult.getErrors());
				}
	}

	public void deletePatientPreference(PatientPreference patientPreference){
		patientPreferenceDataLayer.deletePatientPreference(patientPreference);
	}
}
