package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.SearchStringParsingAlgorithm;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;

public class SsnParsingAlgorithm extends SearchStringParsingAlgorithm {
//	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(SsnParsingAlgorithm.class);

	@Override
	protected String getApplicableSearchStringPattern() {
		return "[0-9]{9}|([0-9]{3}-[0-9]{2}-[0-9]{4})";
	}

	@Override
	public PatientSearchCriteria parse(String searchString) {
		Patient prototype = new Patient();
		String formatedSearchString = formatSsn(searchString);
//		logger.debug("setting criteria ssn and searchString to " + formatedSearchString);
		prototype.setSsn(formatedSearchString);
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(prototype);
		criteria.setSearchString(formatedSearchString);
		return criteria;
	}

	private String formatSsn(String ssn) {
		return ssn.replace("-", "");
	}

}
