package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.SearchStringParsingAlgorithm;

public class LastnameCommaParsingAlgorithm extends SearchStringParsingAlgorithm {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(LastnameCommaParsingAlgorithm.class);

	@Override
	protected String getApplicableSearchStringPattern() {
		return "^[a-z]+,";
	}

	@Override
	public PatientSearchCriteria parse(String searchString) {
		searchString = searchString.replace(",", "").trim();
		searchString = searchString.trim();
		SearchStringParsingAlgorithm parser = new LastNameParsingAlgorithm();
		logger.debug("delegating to parser " + parser.toString() + " with searchstring");
		return parser.parse(searchString);
	}

}
