package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.SearchStringParsingAlgorithm;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;

public class LastnameCommaFirstnameParsingAlgorithm extends SearchStringParsingAlgorithm {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(LastnameCommaFirstnameParsingAlgorithm.class);

	@Override
	protected String getApplicableSearchStringPattern() {
		return "^[a-z][^0-9].*";
	}

	@Override
	public PatientSearchCriteria parse(String searchString) {
		// this can be further optimized using a compiled regex pattern
		Patient prototype = new Patient();
		String[] parts = searchString.split(",");
		if (parts.length >= 1)
			prototype.setLastName(parts[0].trim());
		if (parts.length >= 2)
			prototype.setFirstName(parts[1].trim());
		logger.debug("Parsed searchstring into  lastname=[lastname]; firstname=[firstname] format");
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(prototype);
		return criteria;
	}

}
