package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.SearchStringParsingAlgorithm;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;

public class LastNameParsingAlgorithm extends SearchStringParsingAlgorithm {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(LastNameParsingAlgorithm.class);

	@Override
	protected String getApplicableSearchStringPattern() {
		return "^[^,0-9]+";
	}

	@Override
	public PatientSearchCriteria parse(String searchString) {
		Patient prototype = new Patient();
		logger.debug("setting criteria lastname");
		prototype.setLastName(searchString);
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(prototype);
		return criteria;
	}

}
