package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.SearchStringParsingAlgorithm;

public class LastInitialPlusLastFourSsnParsingAlgorithm extends SearchStringParsingAlgorithm {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(LastInitialPlusLastFourSsnParsingAlgorithm.class);

	@Override
	protected String getApplicableSearchStringPattern() {
		return "^[a-z][0-9]{4}";
	}

	@Override
	public PatientSearchCriteria parse(String searchString) {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		logger.debug("setting criteria LastInitialPlusLastFourOfSsn");
		criteria.setLastInitialPlusLastFourOfSsn(searchString);
		return criteria;
	}

}
