package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.SearchStringParsingAlgorithm;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;

public class CommaFirstNameParsingAlgorithm extends SearchStringParsingAlgorithm {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(CommaFirstNameParsingAlgorithm.class);

	@Override
	protected String getApplicableSearchStringPattern() {
		return "^,[ ]*[a-z][^,0-9]*";
	}

	@Override
	public PatientSearchCriteria parse(String searchString) {
		searchString = searchString.replace(",", "").trim();
		Patient prototype = new Patient();
		logger.debug("setting criteria firstname");
		prototype.setFirstName(searchString);
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(prototype);
		return criteria;
	}

}
