package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser;

import java.util.regex.Pattern;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;

public abstract class SearchStringParsingAlgorithm {
	Pattern pattern = null;

	public boolean isApplicable(String searchString) {
		return (getPattern().matcher(searchString).matches());
	}

	private Pattern getPattern() {
		if (pattern == null)
			pattern = Pattern.compile(getApplicableSearchStringPattern(), Pattern.CASE_INSENSITIVE);
		return pattern;
	}

	protected abstract String getApplicableSearchStringPattern();

	public abstract PatientSearchCriteria parse(String searchString);
}
