package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser;

import java.util.ArrayList;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms.CommaFirstNameParsingAlgorithm;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms.LastFourSsnParsingAlgorithm;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms.LastInitialPlusLastFourSsnParsingAlgorithm;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms.LastNameParsingAlgorithm;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms.LastnameCommaFirstnameParsingAlgorithm;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.patientsearchstringparser.algorithms.SsnParsingAlgorithm;
import com.agilex.healthcare.utility.NullChecker;

public class SearchStringParser {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(SearchStringParser.class);

	private static List<SearchStringParsingAlgorithm> parsers;
	private static SearchStringParsingAlgorithm defaultParser = new LastNameParsingAlgorithm();

	static {
		registerParsers();
	}

	private static void registerParsers() {
		logger.debug("begin registering search string parsers");
		// these are the known parsers. we loop through them to find the
		// applicable parser to handle our search string
		// currently, order is relevant
		parsers = new ArrayList<SearchStringParsingAlgorithm>();
		parsers.add(new LastnameCommaFirstnameParsingAlgorithm());
		parsers.add(new CommaFirstNameParsingAlgorithm());
		parsers.add(new LastFourSsnParsingAlgorithm());
		parsers.add(new LastInitialPlusLastFourSsnParsingAlgorithm());
		parsers.add(new SsnParsingAlgorithm());

		for (SearchStringParsingAlgorithm p : parsers) {
			logger.debug("registered parser");
		}
	}

	public static PatientSearchCriteria parseSearchString(String searchString) {
		logger.debug("begin parse search string");
		PatientSearchCriteria criteria = null;
		SearchStringParsingAlgorithm applicableParser = null;

		if (NullChecker.isNotNullish(searchString))
			searchString = searchString.trim();

		// the purpose of the following loop to find a parser that understand
		// how to handle the search string based on its "pattern"
		for (SearchStringParsingAlgorithm parser : parsers) {
			if (parser.isApplicable(searchString)) {
				applicableParser = parser;
				break;
			}
		}
		if (applicableParser == null)
			applicableParser = defaultParser;
		logger.debug("using parser");
		criteria = applicableParser.parse(searchString);
		logger.debug("done with parser");
		return criteria;
	};
}
