package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class PatientSearchResponseReader {

	private ResponseMessage response;

	private PatientSearchResponseReader(ResponseMessage request) {
		this.response = request;
	}

	public PatientDataFetchRequestReader getRequestReader() {
		return PatientDataFetchRequestReader.fromRequest(response.getRequestMessage());
	}

	public static PatientSearchResponseReader fromResponse(ResponseMessage response) {
		return new PatientSearchResponseReader(response);
	}

	public Patients getPatients() {
		return response.getValue("patients");
	}

	public int getDataListSize() {
		if (getPatients() == null) {
			return 0;
		} else {
			return getPatients().size();
		}
	}

}
