package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class PatientSearchResponseBuilder {
	private ResponseMessage response;

	private PatientSearchResponseBuilder(ResponseMessage response) {
		this.response = response;
	}

	public static PatientSearchResponseBuilder newInstance() {
		ResponseMessage response = new ResponseMessage();
		return new PatientSearchResponseBuilder(response);
	}

	public static PatientSearchResponseBuilder fromSearchResults(Patients patients) {
		ResponseMessage response = new ResponseMessage();
		PatientSearchResponseBuilder builder = new PatientSearchResponseBuilder(response);
		builder.setPatients(patients);
		return builder;
	}

	private PatientSearchResponseBuilder setPatients(Patients patients) {
		response.setValue("patients", patients);
		return this;
	}

	public ResponseMessage build() {
		return response;
	}

}
