package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DataSystem;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;
import com.agilex.healthcare.mobilehealthplatform.utils.DefaultAssigningAuthorityUpdater;
import com.agilex.healthcare.utility.NullChecker;

public class PatientSearchRequestHandler implements RequestHandler {
	private final static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientSearchRequestHandler.class);

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientDataLayer datalayer = getDataLayer(requestMessage);

		PatientSearchRequestReader messageReader = PatientSearchRequestReader.fromRequest(requestMessage);
		Patients patients = datalayer.patientSearch(messageReader.getCriteria());

		fixPatientIdentifier(requestMessage, patients, messageReader.getCriteria().getVistaSiteCode());
		
		PatientFormatter formatter = new PatientFormatter();
		formatter.formatPatients(patients);
		formatter.sort(patients);
		
		return PatientSearchResponseBuilder.fromSearchResults(patients).build();
	}

	private PatientDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}

	private void fixPatientIdentifier(RequestMessage requestMessage, Patients patients, String siteCode) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		DataSystem system = serviceRegistry.getSystemByMessage(requestMessage);

		String targetAssigningAuthority = system.getPatientAssigningAuthority();
		if ("vista".equalsIgnoreCase(system.getSystemIdentifier())){
			if(NullChecker.isNotNullish(siteCode)){
				targetAssigningAuthority = String.format(targetAssigningAuthority, siteCode);
			}else{
				targetAssigningAuthority = String.format(targetAssigningAuthority, getCurrentUser().getVistaLocation());
			}
		}
		
		logger.debug("fixing the assiging authority for patients");
		DefaultAssigningAuthorityUpdater.fillDefaultAssigningAuthority(patients, targetAssigningAuthority);
	}
	
	private MhpUser getCurrentUser(){
		return MhpUserFactory.createFromSecurityContext();
	}
}
