package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;

public class PatientSearchRequestBuilder extends PatientDataFetchRequestBuilder {
	protected PatientSearchRequestBuilder(RequestMessage request) {
		super(request);
	}

	public static PatientSearchRequestBuilder forSearch() {
		RequestMessage request = new RequestMessage();
		PatientSearchRequestBuilder builder = new PatientSearchRequestBuilder(request);
		request.setType("PatientSearch");
		builder.forDomain("patient");
		return builder;
	}

	public PatientSearchRequestBuilder forCriteria(PatientSearchCriteria criteria) {
		request.setValue("criteria", criteria);
		return this;
	}

}