package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Date;

import javax.ws.rs.WebApplicationException;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientMetadata;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class PatientMetadataDataService {
	
	private PatientMetadataDataLayer datalayer;

	public PatientMetadataDataService() {
		datalayer = MhpObjectFactory.getInstance().getPatientMetadataDataLayer();
	}
	
	public PatientMetadata getPatientMetadataByPatientId(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		return datalayer.fetchPatientMetadataByPatientId(patientIdentifier.getUniqueId());
	}

	public PatientMetadata savePatientMetadata(PatientMetadata patientMetadata, ScopeFilter scopeFilter) {
		return datalayer.savePatientMetadata(patientMetadata); 
	}
	
	public Date fetchAndUpdateLastAccessDate(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		Date lastAppointmentRequestAccessDate = null;
		
		PatientMetadata patientMetadata;
		
		try {
			patientMetadata = getPatientMetadataByPatientId(patientIdentifier, scopeFilter);
			lastAppointmentRequestAccessDate = new Date(patientMetadata.getLastAppointmentRequestAccessDate().getTime());
		} catch (WebApplicationException e) {
			Date now = new Date();
			lastAppointmentRequestAccessDate = now;
			patientMetadata = new PatientMetadata();
			patientMetadata.setPatientIdentifier(patientIdentifier);
			patientMetadata.setLastAppointmentRequestAccessDate(now);
		}
		
		updateLastAccessDate(patientMetadata, scopeFilter);
		
		return lastAppointmentRequestAccessDate; 
	}
	
	private void updateLastAccessDate(PatientMetadata patientMetadata, ScopeFilter scopeFilter) {
		patientMetadata.setLastAppointmentRequestAccessDate(new Date());
		savePatientMetadata(patientMetadata, scopeFilter);
	}
}
