package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.ArrayList;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientEdipiIcn;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class PatientInternalDataService {
	
	private static final String ICN = "ICN";
	private static final String EDIPI = "EDIPI";
	
	private PatientInternalDataLayer datalayer = null;
	
	public PatientInternalDataService() {
		datalayer = MhpObjectFactory.getInstance().getPatientInternalDataLayer();	
	}
	
	public Patient fetchPatientById(String patientId){
		return datalayer.fetchPatientById(patientId);
	}
	
	public Patient savePatient(Patient patient) {
		return datalayer.savePatient(patient);
	}
	
	public List<PatientEdipiIcn> savePatientICN(PatientIdentifier patientIdentifier) {
		
		// Get all the identifiers for given patient identifier 
		PatientIdentifiers correspondingIdentifiers = MhpObjectFactory.getInstance().getPatientCorrelationService()
				.getCorrespondIdentifiers(patientIdentifier);
		
		//Save to database
		List<PatientEdipiIcn> patientEdipiIcns = new ArrayList<PatientEdipiIcn>();
		
		List<String> icns = new ArrayList<String>();
		String edipi = null;
		for (PatientIdentifier patientIdntfr : correspondingIdentifiers) {
			if (EDIPI.equalsIgnoreCase(patientIdntfr.getAssigningAuthority())) {
				edipi = patientIdntfr.getUniqueId();
			} else if (ICN.equalsIgnoreCase(patientIdntfr.getAssigningAuthority())) {
				icns.add(patientIdntfr.getUniqueId());
			}
		}
		patientEdipiIcns = getPatientEdipiIcns(edipi, icns);
		
		List<PatientEdipiIcn> savedPatientEdipiIcns = new ArrayList<PatientEdipiIcn>();
		if (!patientEdipiIcns.isEmpty()) {
			savedPatientEdipiIcns = datalayer.savePatientICN(patientEdipiIcns);
		}
		return savedPatientEdipiIcns;
	}

	private List<PatientEdipiIcn> getPatientEdipiIcns(String edipi, List<String> icns) {
		List<PatientEdipiIcn> patientEdipiIcns = new ArrayList<PatientEdipiIcn>();
		PatientEdipiIcn patientEdipiIcn = null;
		for (String icn : icns) {
			patientEdipiIcn = new PatientEdipiIcn();
			patientEdipiIcn.setEdipi(edipi);
			patientEdipiIcn.setIcn(icn);
			patientEdipiIcn.setActiveFlag(true);
			patientEdipiIcns.add(patientEdipiIcn);
		}
		return patientEdipiIcns;
	}	
}
