package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.List;
import java.util.concurrent.Callable;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientEdipiIcn;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class PatientIcnService implements Callable<String> {

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientIcnService.class);
	private static final String EDIPI = "EDIPI";
	
	private String patientId;

    public PatientIcnService(String patientId) {
        this.patientId = patientId;
    }
    
	@Override
	public String call() throws Exception {
		
		 PatientIdentifier patientIdentifier = new PatientIdentifier(EDIPI, patientId);
		 PatientInternalDataService dataservice = new PatientInternalDataService();
		 List<PatientEdipiIcn> savedEdipiIcns = dataservice.savePatientICN(patientIdentifier);
		 //logger.debug("savedEdipiIcns  " + savedEdipiIcns);
		 String resultIcn = null;
		 if (!savedEdipiIcns.isEmpty()) {
			 resultIcn = savedEdipiIcns.get(0).getIcn(); 
		 }
		 return resultIcn;
	}

}
