package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;

public class PatientFetchResponseReader {

	private ResponseMessage response;

	private PatientFetchResponseReader(ResponseMessage request) {
		this.response = request;
	}

	public PatientDataFetchRequestReader getRequestReader() {
		return PatientDataFetchRequestReader.fromRequest(response.getRequestMessage());
	}

	public static PatientFetchResponseReader fromResponse(ResponseMessage response) {
		return new PatientFetchResponseReader(response);
	}

	public Patients getPatients() {
		return response.getValue("patients");
	}

	public Patient getPatient() {
		return response.getValue("patient");
	}

	public int getDataListSize() {
		if (getPatients() == null) {
			return 0;
		} else {
			return getPatients().size();
		}
	}

	public PatientDemographics getDemographics() {
		return response.getValue("demographics");
	}
	
	public NextOfKin getNextOfKin() {
		return response.getValue("nextOfKin");
	}
	
	public PatientDemographics getContactInfo() {
		return response.getValue(Domain.contactInfo);
	}

	public PatientPreference getPreference(){
		return response.getValue("preference");
	}
}
