package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;

public class PatientFetchResponseBuilder {
	private ResponseMessage response;

	private PatientFetchResponseBuilder(ResponseMessage response) {
		this.response = response;
	}

	public static PatientFetchResponseBuilder newInstance() {
		ResponseMessage response = new ResponseMessage();
		return new PatientFetchResponseBuilder(response);
	}

	public static PatientFetchResponseBuilder fromPatientData(Patient patient) {
		ResponseMessage response = new ResponseMessage();
		PatientFetchResponseBuilder builder = new PatientFetchResponseBuilder(response);
		builder.setPatient(patient);
		return builder;
	}

	private PatientFetchResponseBuilder setPatient(Patient patient) {
		response.setValue("patient", patient);
		return this;
	}

	public static PatientFetchResponseBuilder fromDemographics(PatientDemographics demographics) {
		ResponseMessage response = new ResponseMessage();
		PatientFetchResponseBuilder builder = new PatientFetchResponseBuilder(response);
		builder.setDemographics(demographics);
		return builder;
	}
	
	public static PatientFetchResponseBuilder fromNextOfKin(NextOfKin nextOfKin) {
		ResponseMessage response = new ResponseMessage();
		PatientFetchResponseBuilder builder = new PatientFetchResponseBuilder(response);
		builder.setNextOfKin(nextOfKin);
		return builder;
	}
	
	public static PatientFetchResponseBuilder fromContactInfo(PatientDemographics contacts) {
		ResponseMessage response = new ResponseMessage();
		PatientFetchResponseBuilder builder = new PatientFetchResponseBuilder(response);
		builder.setContactInfo(contacts);
		return builder;
	}

	private PatientFetchResponseBuilder setDemographics(PatientDemographics demographics) {
		response.setValue("demographics", demographics);
		return this;
	}
	
	private PatientFetchResponseBuilder setNextOfKin(NextOfKin nextOfKin) {
		response.setValue("nextOfKin", nextOfKin);
		return this;
	}
	
	private PatientFetchResponseBuilder setContactInfo(PatientDemographics contactInfo) {
		response.setValue(Domain.contactInfo, contactInfo);
		return this;
	}

	public ResponseMessage build() {
		return response;
	}

}
