package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;

public class PatientFetchRequestBuilder extends PatientDataFetchRequestBuilder {
	protected PatientFetchRequestBuilder(RequestMessage request) {
		super(request);
	}

	public static PatientFetchRequestBuilder forRetrieve() {
		RequestMessage request = new RequestMessage();
		PatientFetchRequestBuilder builder = new PatientFetchRequestBuilder(request);
		request.setType("FetchPatient");
		builder.forDomain("patient");
		return builder;
	}

	public static PatientFetchRequestBuilder forRetrieveDemographics() {
		RequestMessage request = new RequestMessage();
		PatientFetchRequestBuilder builder = new PatientFetchRequestBuilder(request);
		request.setType("FetchPatientDemographics");
		builder.forDomain("supplemental-demographics");
		return builder;
	}
	
	public static PatientFetchRequestBuilder forNextOfKin() {
		RequestMessage request = new RequestMessage();
		PatientFetchRequestBuilder builder = new PatientFetchRequestBuilder(request);
		request.setType("FetchPatientNextOfKin");
		builder.forDomain("next-of-kin");
		return builder;
	}
	
	public static PatientFetchRequestBuilder forContactInfo() {
		RequestMessage request = new RequestMessage();
		PatientFetchRequestBuilder builder = new PatientFetchRequestBuilder(request);
		request.setType("FetchContactInfo");
		builder.forDomain(Domain.contactInfo);
		return builder;
	}

}