package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.PagingResults;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientSearchResults;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.NullChecker;

public class Paging {
	private final static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(Paging.class);
	public final static int DEFAULT_MAX_RECORDS = 20;

	public PatientSearchResults enforceMaxRecords(Patients patients, PatientSearchPaging pagingInfo) {
		PagingResults paging = new PagingResults();
		paging.setTotalResults(patients.size());

		if (pagingInfo == null)
			pagingInfo = createDefaultPagingInformation();
		if (NullChecker.isNullish(pagingInfo.getPageNumber()))
			pagingInfo.setPageNumber(1);
		if (NullChecker.isNullish(pagingInfo.getMaxRecords()))
			pagingInfo.setMaxRecords(DEFAULT_MAX_RECORDS);

		paging.setPageSize(pagingInfo.getMaxRecords());
		
		if (NullChecker.isNotNullish(patients)) {
			int startIndex = (pagingInfo.getPageNumber() - 1) * pagingInfo.getMaxRecords();
			int endIndex = Math.min(patients.getSize(), startIndex + pagingInfo.getMaxRecords());
			if (startIndex > endIndex) {
				patients = new Patients();
			} else if (startIndex == 0 && endIndex == patients.getSize()) {
				// just use original patients
			} else {
				if (endIndex != patients.getSize())
					paging.setNextPage(pagingInfo.getPageNumber() + 1);

				List<Patient> list = patients.subList(startIndex, endIndex);
				logger.debug(String.format("trimming patient list from %s to %s", patients.size(), list.size()));
				if (patients.size() == list.size())
					logger.warn("inefficient trim of patients");
				patients = new Patients();
				patients.addAll(list);

			}
		}

		paging.setThisPage(pagingInfo.getPageNumber());

		PatientSearchResults searchResults = new PatientSearchResults(patients);
		searchResults.setPaging(paging);
		return searchResults;
	}

	public PatientSearchPaging createDefaultPagingInformation() {
		PatientSearchPaging pagingInfo = new PatientSearchPaging();
		pagingInfo.setMaxRecords(DEFAULT_MAX_RECORDS);
		pagingInfo.setPageNumber(1);
		return pagingInfo;
	}
}
