package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;

public class FetchNextOfKinRequestHandler extends BasicPatientRequestHandler<PatientSupplementalDemographicsDataLayer> implements RequestHandler {

	public FetchNextOfKinRequestHandler() {
		this.domain = Domain.nextOfKin;
	}
	
	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		
		PatientSupplementalDemographicsDataLayer dataLayer = getDataLayer(requestMessage);
		PatientDataFetchRequestReader requestReader = PatientDataFetchRequestReader.fromRequest(requestMessage);

		PatientIdentifier translatedIdentifier = translatePatientIdentifier(requestReader);

		NextOfKin nextOfKin = null;

		if (translatedIdentifier != null)
			nextOfKin = dataLayer.fetchPatientNextOfKin(translatedIdentifier);

		return PatientFetchResponseBuilder.fromNextOfKin(nextOfKin).build();
	}

}
