package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;

public class FetchContactInfoRequestHandler extends BasicPatientRequestHandler<PatientSupplementalDemographicsDataLayer> implements RequestHandler {

	public FetchContactInfoRequestHandler() {
		this.domain = Domain.contactInfo;
	}
	
	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientSupplementalDemographicsDataLayer dataLayer = getDataLayer(requestMessage);
		PatientDataFetchRequestReader requestReader = PatientDataFetchRequestReader.fromRequest(requestMessage);

		PatientIdentifier translatedIdentifier = translatePatientIdentifier(requestReader);

		PatientDemographics contactInfo = null;

		if (translatedIdentifier != null)
			contactInfo = dataLayer.fetchPatientContactInformation(translatedIdentifier);

		return PatientFetchResponseBuilder.fromContactInfo(contactInfo).build();
	}
	
}
