package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Collection;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.*;

public class BasicPatientRequestHandler<TDataLayer> {
	
	String domain = "";

	protected TDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
	
	protected Collection<DataSystem> determineDataSystemList(ScopeFilter scopeFilter) {
		DomainServiceRegistry registry = new DomainServiceRegistry();
		return registry.getDataSystems(scopeFilter, this.domain);
	}
	
	protected PatientIdentifier translatePatientIdentifier(PatientDataFetchRequestReader requestReader) {
		// if there are multiple patient id's in vista for a given patient, we will pick the first one
		Collection<DataSystem> dataSystems = determineDataSystemList(requestReader.getScopeFilter());

		for (DataSystem targetDataSystem : dataSystems) {
			
			String targetSystemIdentifier = targetDataSystem.getSystemIdentifier();
			String targetAssigningAuthority = targetDataSystem.getPatientAssigningAuthority();
			
			if ("vista".equalsIgnoreCase(targetSystemIdentifier)) {
				MhpUser currentUser = getCurrentUser();
				targetAssigningAuthority = String.format(targetDataSystem.getPatientAssigningAuthority(), currentUser.getVistaLocation());
			}
			
			if (targetAssigningAuthority.equalsIgnoreCase(requestReader.getPatientIdentifier().getAssigningAuthority())) {
				return requestReader.getPatientIdentifier();
			} else {
				PatientIdentifiers correspondingIdentifiers = MhpObjectFactory.getInstance().getPatientCorrelationService().getCorrespondIdentifiers(requestReader.getPatientIdentifier());
				for (PatientIdentifier userIdentifier : correspondingIdentifiers) {
					if (userIdentifier.getAssigningAuthority().equalsIgnoreCase(targetAssigningAuthority)) {
						return userIdentifier;
					}
				}
			}
		}

		return null;
	}
	
	private MhpUser getCurrentUser(){
		return MhpUserFactory.createFromSecurityContext();
	}
	
}
