package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import java.util.Comparator;

import com.agilex.healthcare.mobilehealthplatform.domain.PainGoal;
import com.agilex.healthcare.utility.PainGoalStatus;

public class PainGoalsSortByStatusAndCreationDateComparator implements Comparator<PainGoal> {
	
	@Override
	public int compare(PainGoal goal1, PainGoal goal2) {
		int c;
		int SortAdjustmentForDescending = -1;
		
		c = translateStatusOrdering(goal1.getStatus()).compareTo(translateStatusOrdering(goal2.getStatus()));
		
		if (c==0) {
			c = goal1.getDateStarted().compareTo(goal2.getDateStarted()) * SortAdjustmentForDescending;
		}
		
		return c;
	}

	private Integer translateStatusOrdering (PainGoalStatus status) {
		Integer statusOrder = 3;

		if (PainGoalStatus.PainGoalStatusActive == status) {
			statusOrder = 1;
		} else if (PainGoalStatus.PainGoalStatusComplete == status) {
			statusOrder = 2;
		} 
	
		return statusOrder;
	}
}
