package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paingoals.PainGoalsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoal;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoals;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;

public class FetchPainGoalsRequestHandler extends AbstractFetchPatientDataListRequestHandler<PainGoalsDataLayer, PainGoals, PainGoal> {
	@Override
	protected PainGoals invokeDataLayerToFetchList(PainGoalsDataLayer dataLayer, RequestMessage requestMessage, PatientDataFetchRequestReader reader) {
		
		PainGoals painGoals = null;
		
		String option = (String)requestMessage.getValue(PainGoalDataService.RequestKeyForShouldIncludeDeletedGoals);

        DateFilter dateFilter = reader.getDateFilter();
        if (dateFilter == null){
            dateFilter = DateFilterFactory.createEmptyFilter();
        }

        if (PainGoalDataService.RequestKeyForShouldIncludeDeletedGoalsTrue.equalsIgnoreCase(option)) {
			painGoals = dataLayer.fetchAllPainGoals(reader.getPatientId(), dateFilter);
		} else {
			painGoals = dataLayer.fetchPainGoals(reader.getPatientId(), dateFilter);
		}
		
		return painGoals;
	}
}
