package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paingoals.PainGoalsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoalEntry;

public class FetchPainGoalEntriesRequestHandler extends AbstractFetchPatientDataListRequestHandler<PainGoalsDataLayer, PainGoalEntries, PainGoalEntry> {
	
	@Override
	protected PainGoalEntries invokeDataLayerToFetchList(PainGoalsDataLayer dataLayer, RequestMessage requestMessage, PatientDataFetchRequestReader reader) {
		
		PainGoalEntries painGoalEntries = dataLayer.fetchAllPainGoalEntries(reader.getPatientId(), reader.getDataIdentifier());
		
		return painGoalEntries;
	}
}
