package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paingoals.PainGoalsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchPainGoalByIdRequestHandler extends AbstractFetchPatientDataRequestHandler<PainGoalsDataLayer, PainGoal> {

	@Override
	protected PainGoal invokeDataLayerToFetchSingleItem(PainGoalsDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		return datalayer.getPainGoal(patientIdentifier.getUniqueId(), dataId);
	}

}
