package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractSavePatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paingoals.PainGoalsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoalEntry;

public class CreateNewPainGoalEntryRequestHandler extends AbstractSavePatientDataRequestHandler<PainGoalsDataLayer, PainGoalEntry> {
	
	@Override
	protected PainGoalEntry invokeDataLayerToSaveItem(PainGoalsDataLayer datalayer, PainGoalEntry data, RequestMessage requestMessage) {
		String goalId = (String)requestMessage.getValue(PainGoalDataService.RequestKeyForPainGoalID);

		return datalayer.createNewPainGoalEntry(data, goalId);
	}
}
