package com.agilex.healthcare.mobilehealthplatform.datalayer.pain;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import org.apache.log4j.Logger;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataEditRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

import edu.emory.mathcs.backport.java.util.Collections;

public class PainDiaryEntryDataService {
    private static final Logger logger = Logger.getLogger(PainDiaryEntryDataService.class);

	private Router router = new Router();;

	public PainDiaryEntryDataService() {
	}
	
	public PainDiaryEntries fetchPainDiaryEntries(PatientIdentifier patientIdentifier) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.painDiaryEntry).forPatientIdentifier(patientIdentifier).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage responseMessage = router.execute(request);
		PainDiaryEntries painDiaryEntries = PatientDataResponseReader.<PainDiaryEntries, PainDiaryEntry> fromResponse(responseMessage).getDataListNoNull(PainDiaryEntries.class);		
		
		sortPainDiaryEntries(painDiaryEntries);
		
		return painDiaryEntries;
	}

	public PainDiaryEntries fetchPainDiaryEntries(PatientIdentifier patientIdentifier, DateFilter filter) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.painDiaryEntry).forPatientIdentifier(patientIdentifier).forDateFilter(filter).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage responseMessage = router.execute(request);
		PainDiaryEntries painDiaryEntries = PatientDataResponseReader.<PainDiaryEntries, PainDiaryEntry> fromResponse(responseMessage).getDataListNoNull(PainDiaryEntries.class);		
		
		sortPainDiaryEntries(painDiaryEntries);
		
		return painDiaryEntries;
	}

	private void sortPainDiaryEntries(PainDiaryEntries painDiaryEntries) {
		Collections.sort(painDiaryEntries, new PainDiaryEntriesSortByStatusAndCreationDateComparator());
	}

	public PainDiaryEntry fetchPainDiaryEntry(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveSingleById().forDomain(Domain.painDiaryEntry).forPatientIdentifier(patientIdentifier).forDataIdentifier(dataIdentifier).build();
		ResponseMessage responseMessage = router.execute(request);
		PainDiaryEntry painDiaryEntry = PatientDataResponseReader.<PainDiaryEntries, PainDiaryEntry> fromResponse(responseMessage).getDataItem();
		return painDiaryEntry;
	}

	public PainDiaryEntry createNewPainDiaryEntry(PainDiaryEntry data) {
		logger.debug("creating a new pain diary entry");

        addSurrogate(data);

		RequestMessage request = PatientDataEditRequestBuilder.forCreate().forDomain(Domain.painDiaryEntry).forData(data).forPatientIdentifier(data.getPatientIdentifier())
				.forScope(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage responseMessage = router.execute(request);
		PainDiaryEntry createdPainDiaryEntry = PatientDataResponseReader.<PainDiaryEntries, PainDiaryEntry> fromResponse(responseMessage).getDataItem();

		return createdPainDiaryEntry;
	}

	public PainDiaryEntry updatePainDiaryEntry(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier, PainDiaryEntry painDiaryEntry) {
		logger.debug("updating a pain diary entry");

        addSurrogate(painDiaryEntry);

        RequestMessage request = PatientDataEditRequestBuilder.forUpdate().forDomain(Domain.painDiaryEntry).forData(painDiaryEntry).forDataIdentifier(dataIdentifier)
				.forPatientIdentifier(patientIdentifier).forScope(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage responseMessage = router.execute(request);
		PainDiaryEntry updatedPainDiaryEntry = PatientDataResponseReader.<PainDiaryEntries, PainDiaryEntry> fromResponse(responseMessage).getDataItem();

		updatedPainDiaryEntry.setPatientIdentifier(patientIdentifier);
		updatedPainDiaryEntry.setDataIdentifier(dataIdentifier);
		return updatedPainDiaryEntry;
	}

    private void addSurrogate(PatientData data) {
        MhpUserFactory.addSurrogateToPatientData(data);
    }
}
