package com.agilex.healthcare.mobilehealthplatform.datalayer.pain;

import java.util.Comparator;

import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;

public class PainDiaryEntriesSortByStatusAndCreationDateComparator implements Comparator<PainDiaryEntry> {

	@Override
	public int compare(PainDiaryEntry entry1, PainDiaryEntry entry2) {
		int c;
		int SortAdjustmentForDescending = -1;

		c = translateStatusOrdering(entry1.isCompleted()).compareTo(translateStatusOrdering(entry2.isCompleted()));
		
		if (c==0) {
			c = entry1.getDateCreated().compareTo(entry2.getDateCreated()) * SortAdjustmentForDescending;
		}
		
		return c;
	}

	private Integer translateStatusOrdering (boolean isComplete) {
		Integer statusOrder;

		if (isComplete) {
			statusOrder = 2;
		} else {
			statusOrder = 1;
		}
		
		return statusOrder;
	}

}
