package com.agilex.healthcare.mobilehealthplatform.datalayer.pain;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;

public class FetchPainDiaryEntryRequestHandler extends AbstractFetchPatientDataListRequestHandler<PainDiaryDataLayer, PainDiaryEntries, PainDiaryEntry>{
	@Override
	protected PainDiaryEntries invokeDataLayerToFetchList(PainDiaryDataLayer dataLayer, RequestMessage requestMessage, PatientDataFetchRequestReader reader) {
		return dataLayer.fetchPainDiaryEntries(reader.getPatientId(), reader.getDateFilter());
	}
}
