package com.agilex.healthcare.mobilehealthplatform.datalayer.pain;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchPainDiaryEntryByIdRequestHandler extends AbstractFetchPatientDataRequestHandler<PainDiaryDataLayer, PainDiaryEntry> {

	@Override
	protected PainDiaryEntry invokeDataLayerToFetchSingleItem(PainDiaryDataLayer dataLayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		return dataLayer.fetchPainDiaryEntry(patientIdentifier.getUniqueId(), dataId);
	}
}
