package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataEditRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.PatientIdentifierHelper;

public class MygoalsDataService {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MygoalsDataService.class);

	private Router router;

	public MygoalsDataService() {
		this.router = new Router();
	}

	public MygoalsDataService(Router router) {
		this.router = router;
	}
	
	public Mygoals saveMygoals(Mygoals mygoals, ScopeFilter scopeFilter) {
		logger.debug("request to save mygoals for specfic patient id");

		logger.debug("about to save mygoals");

  		RequestMessage message = PatientDataEditRequestBuilder.forCreate().forDomain(Domain.mygoals).forData(mygoals).forScope(scopeFilter).build();
		ResponseMessage response = router.execute(message);
		Mygoals savedMygoals = PatientDataResponseReader.<MygoalsList, Mygoals> fromResponse(response).getDataItem();

		logger.debug("saved mygoals");

		savedMygoals.setPatientIdentifier(mygoals.getPatientIdentifier());

		return savedMygoals;
	}	
	
	public MygoalsList fetchLatestMygoalsByType(String inventoryType, PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		logger.debug("fetchLatestMygoals by inventoryType");
		MygoalsList mostRecentMygoals = fetchMostRecentMygoalsByType(inventoryType, patientIdentifier, scopeFilter);
		return mostRecentMygoals;

	}

	public MygoalsList fetchLatestMygoals(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		logger.debug("fetchLatestMygoals by patientIdentifier");
		MygoalsList mostRecentMygoals = fetchMostRecentMygoals(patientIdentifier, scopeFilter);
		return mostRecentMygoals;

	}
	
	public Mygoals fetchMygoalsById(PatientIdentifier patientIdentifier, String responseId) {
		logger.debug("fetch mygoals by id");
		Mygoals retrievedMygoals = getMygoalsDataLayer().fetchMygoalsById(patientIdentifier.getUniqueId(), responseId);
		PatientIdentifierHelper.updatePatientIdentifier(retrievedMygoals, patientIdentifier);	
		return retrievedMygoals;
	}
	
	public MygoalsList fetchMygoalsByPatient(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		logger.debug("fetchMygoalsByPatient by patientId");

		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.mygoals).forPatientIdentifier(patientIdentifier).forScopeFilter(scopeFilter).build();

		ResponseMessage responseMessage = router.execute(request);
		MygoalsList mygoalsList = PatientDataResponseReader.<MygoalsList, Mygoals> fromResponse(responseMessage).getDataListNoNull(
				MygoalsList.class);

		PatientIdentifierHelper.updatePatientIdentifier(mygoalsList, patientIdentifier);
		return mygoalsList;
	}
	
	private MygoalsDataLayer getMygoalsDataLayer() {
		return getMygoalsDataLayer(ScopeFilter.getInstanceForLongitudinalScope());
	}

	private MygoalsDataLayer getMygoalsDataLayer(ScopeFilter scopeFilter) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByScopeFilter(scopeFilter, Domain.mygoals);
	}

	private MygoalsList fetchMostRecentMygoalsByType(String inventoryType, PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.mygoals).forPatientIdentifier(patientIdentifier)
				.forScopeFilter(scopeFilter).setChildMessageType("{domain}.fetchMostRecentMygoals").setValue("inventory-type", inventoryType).build();

		ResponseMessage responseMessage = router.execute(request);
		MygoalsList mygoalsList = PatientDataResponseReader.<MygoalsList, Mygoals> fromResponse(responseMessage).getDataListNoNull(
				MygoalsList.class);

		return mygoalsList;

	}	

	
	private MygoalsList fetchMostRecentMygoals(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.mygoals).forPatientIdentifier(patientIdentifier)
				.forScopeFilter(scopeFilter).setChildMessageType("{domain}.fetchMostRecentMygoalsList").build();

		ResponseMessage responseMessage = router.execute(request);
		MygoalsList mygoalsList = PatientDataResponseReader.<MygoalsList, Mygoals> fromResponse(responseMessage).getDataListNoNull(
				MygoalsList.class);

		return mygoalsList;

	}	
	
	
}
